# Agent Evaluation Example - Insurance Company

This directory gives an example of running Arklex User Simulator CLI with an example customer service agent for **insurance company use case**. You can follow the example to evaluate your own agent.

> This example includes two types of agents:
> - **Option 1**: OpenAI agent that directly   uses the OpenAI API to interact with the user simulator.
> - **Option 2**: Customized in-house agent exposed through A2A Protocol or Chat Completions-compatible interface to interact with the user simulator.

## Data preparation

This example already includes a `data` folder in this directory (i.e., `examples/bank-insurance/data`). You can freely add, remove, or update knowledge files (`.md`, `.pdf`, `.doc`, etc.) in that folder to match your own use case.

## Option 1: OpenAI Agent

### Option 1.1: OpenAI Agent

Steps to run:

1. Set the following environment variables:
    ```bash
    export OPENAI_API_KEY="<YOUR_OPENAI_API_KEY>"
    ```
2. Rename `agent_config_openai.json` to `agent_config.json`. If `agent_config.json` already exists, first rename the original file to another name to avoid overwriting it.
3. Configure `config.yaml` for this example (the default configuration is sufficient for this example).
4. From the `root` folder, start the user simulator:
   ```bash
   ./run_arksim.sh run ./examples/bank-insurance/config.yaml
   ```

### Option 1.2: Azure OpenAI Agent

> **Note**: this has to be run on Azure service or App.

Set the following environment variables:

```bash
export AZURE_OPENAI_ENDPOINT="<YOUR_AZURE_OPENAI_ENDPOINT>"
export AZURE_OPENAI_API_VERSION="<YOUR_AZURE_OPENAI_API_VERSION>"
export AZURE_CLIENT_ID="<YOUR_AZURE_CLIENT_ID>"
export LLM_PROVIDER="azure"
export AZURE_OPENAI_DEPLOYMENT_NAME="<YOUR_AZURE_OPENAI_DEPLOYMENT_NAME>" # Optional: This model is used by this Azure Agent demo for generating the responses. If you built your own Agent, then you don't need to set this.
```

Sample:

```bash
export AZURE_OPENAI_ENDPOINT="https://openai-for-user-simulator.openai.azure.com/"
export AZURE_OPENAI_API_VERSION="2025-01-01-preview"
export AZURE_CLIENT_ID="abcdefgh-1234-5678-90ab-cdefghijklmnop"
export LLM_PROVIDER="azure"
export AZURE_OPENAI_DEPLOYMENT_NAME="gpt-5.1"
```

Steps to run:

1. Rename `agent_config_azure_openai.json` to `agent_config.json`. If `agent_config.json` already exists, first rename the original file to another name to avoid overwriting it.
2. Configure `config.yaml` for this example:
   ```yaml
   agent_setup_dir: ./examples/bank-insurance
   provider: azure
   model: <e.g. gpt-5.1>  # Required: Notice that this model is the LLM-based generation model used by the user simulator for generation. 
   embedding_model: <e.g. text-embedding-3-small> # Required: This model is used by the user simulator for embedding the knowledge.
   ```
3. From the `root` folder, start the user simulator:
   ```bash
   ./run_arksim.sh run ./examples/bank-insurance/config.yaml
   ```

Note: Azure OpenAI Agent does not support metadata in the request body. If setting `enable_metadata` to `true` in the request body, there will be an error when sending the request.


## Option 2: In-house Agent (`agent_server`)

In the `./examples/bank-insurance/agent_server` folder, we provide a sample RAG-based agent implemented with LangGraph that can be exposed with A2A Protocol or through Chat Completions interface.

Steps to run:

1. Choose an agent configuration and rename it to `agent_config.json` (if `agent_config.json` already exists, rename or remove it first).
   - For **A2A (recommended)**: `agent_config_a2a.json` → `agent_config.json`
   - For **Chat Completions**: `agent_config_chat_completions.json` → `agent_config.json`

   The agent configs support environment variable substitution using `${ENV_VAR_NAME}` syntax (for example, `${A2A_CLIENT_CREDENTIAL}` or `${OPENAI_API_KEY}`).

2. Install the sample agent dependencies:

   - Create a virtual environment (Python 3.11 recommended) and install dependencies:

     1. Create and activate the environment:
        ```bash
        conda create -n bank_venv python=3.11
        conda activate bank_venv
        ```
     2. Navigate to the sample agent directory and install requirements:
        ```bash
        cd examples/bank-insurance/agent_server
        pip install -r requirements.txt
        ```

3. Start one of the sample agents:

   - **3.1 A2A agent server**

     This exposes an A2A-compatible agent on port `9999`.

     ```bash
     export OPENAI_API_KEY=<YOUR_OPENAI_API_KEY>
     cd ../../../
     python -m examples.bank-insurance.agent_server.a2a.server
     ```

   - **3.2 Chat Completions wrapper**

     This exposes an OpenAI Chat Completions-compatible endpoint on port `8888` at `/chat/completions`.

     ```bash
     export OPENAI_API_KEY=<YOUR_OPENAI_API_KEY>
     cd ../../../
     python -m examples.bank-insurance.agent_server.chat_completions.server
     ```
      For the chat completions server, if `enable_metadata` is set to `true` in the request body, the following metadata will be sent together with the user message:
      - `chat_id`: The chat ID of the conversation.
      - `user_attributes`: The user attributes of the conversation.
      - `user_goal`: The user goal of the conversation.
      - `knowledge`: The knowledge of the conversation.

   You can also adapt these servers to call your own backend agent by following the comments in `agent_server/chat_completions/server.py` (for Chat Completions) or by implementing your own A2A-compatible executor in `agent_server/a2a`.

3. Configure `config.yaml` for this example

4. From the `root` folder, start the user simulator:
   ```bash
   ./run_arksim.sh run ./examples/bank-insurance/config.yaml
   ```
