# What is Car Insurance and How Does it Work?

## Understanding Car Insurance in Canada

It's illegal to drive your car without insurance in Canada—not to mention, insurance is there to protect you as the owner/driver. Car insurance is mandatory, which means vehicles must have insurance before they can be driven. The purpose of this insurance is to protect you from the financial loss that comes with any potential accidents.

Having car insurance can help protect you if you're held responsible for an accident that causes damage to another person or their car. Apart from the mandatory coverage that's required by law, there are also optional coverages you can add to your policy to give you extra protection.

Once a contract is made between you and your insurer, you'll be responsible for paying a premium which will keep your car insurance policy active and ready should anything happen to you and/or your car.

## Public vs Private Car Insurance

Car insurance in Canada is divided into public insurance and private insurance:

**Public Car Insurance:** The company that provides insurance is a government-owned corporation. You may also have the option to increase your coverage with a privately-owned, publicly traded, or mutual insurance company.

**Private Car Insurance:** The companies that offer insurance are privately owned, publicly traded, or mutual companies.

### Insurance Type by Province

| Province | Type of Insurance |
|----------|------------------|
| British Columbia | Public |
| Alberta | Private |
| Manitoba | Public |
| Saskatchewan | Public |
| Ontario | Private |
| Quebec | Hybrid |
| New Brunswick | Private |
| Nova Scotia | Private |
| Prince Edward Island | Private |
| Newfoundland & Labrador | Private |
| Northwest Territories | Private |
| Nunavut | Private |
| Yukon | Private |

## Mandatory Car Insurance Coverage

While auto insurance is needed to drive a car anywhere in Canada, the mandatory coverage required will depend on your province or territory. Typically, mandatory coverage includes:

| Coverage Type | Description |
|--------------|-------------|
| **Liability** | If you injure someone or damage property and are sued for damages, the cost of that damage and legal fees may be covered. |
| **Accident Benefits** | Provides benefits if you are injured in an automobile accident, regardless of who caused the accident. |
| **Direct Compensation** | Damages to your car are covered by your insurer if you're not at fault. However, at-fault damages would be covered by optional collision coverage. |
| **Uninsured Automobile Coverage** | Medical costs and damage are covered if an uninsured driver is at fault. |

## Optional Car Insurance Coverages

| Coverage Type | Description |
|--------------|-------------|
| **Specified Perils** | Protects your vehicle from specified perils such as losses caused by fire, floods, hail, or theft. |
| **Comprehensive Coverage** | Covers all other insured damage caused to your vehicle (except collision or upset). |
| **Collision or Upset** | Covers damage to your vehicle caused by a traffic collision with another vehicle or object. |
| **All Perils** | This option combines the coverages of Collision or Upset and Comprehensive. |

## Third Party Liability Insurance

Third party liability insurance is mandatory across Canada. If you're responsible for an accident that injures someone or damages their property, third party liability insurance financially protects you if you're sued. This type of insurance has two key components:

- **Bodily Injury:** Covers losses or costs (for example, medical bills) for another person's injuries.
- **Property Damage:** Covers the cost of repairing or replacing property, like another person's car.

Each province has its own minimum required limits for liability coverage. However, it's always a good idea to review the coverage you're getting, since you don't want to be caught with too little coverage.

## Comprehensive vs Collision Coverage

Both offer valuable protection, but they each cover different risks:

- **Comprehensive Coverage:** Protects your car from non-collision incidents like theft and vandalism.
- **Collision Coverage:** Kicks in if you're involved in an accident with another vehicle or with an object like a tree or guardrail.

## How to Get Your Vehicle Insured

1. **Get car insurance quotes online or call for a quote.** Many insurance providers offer online quotes, making this first step easy.

2. **Compare quotes.** Don't just look at price alone. A quote might offer a low price, but when you compare the coverage being offered, it may turn out not to be the best deal for your money.

3. **Purchase your car insurance policy.** Once you've compared the quotes and decided on the one that works best for you, you can make your purchase online or over the phone.

*The content on this page is for general information purposes only and does not constitute legal advice. Coverages described herein may be subject to additional eligibility criteria, limitations and exclusions.*
