# What is Home Insurance?

## Understanding Home Insurance

Owning a home may be your biggest investment, so how can you protect it? Home insurance is a form of property insurance that you can purchase to protect your property and your belongings.

It may not be something we think about every day, but unexpected incidents can happen at any time to your home, which is why home insurance is important to have. Home insurance originated from something called "fire insurance." As the name suggests, fire insurance was used to cover fires, but has since evolved to "home insurance" since it now covers much more.

## Do I Need Home Insurance?

We strongly recommend that you have home insurance, simply for all the value it offers—even if home insurance isn't mandated by law the same way that car insurance is. Keep in mind that if you're looking to purchase a home, or if you're a homeowner that has applied for a mortgage, your lender will likely require you to purchase home insurance first.

Having home insurance can protect you from having to pay a large lump sum to repair damages to your property and personal belongings if something happens to or in your home. Although home insurance isn't necessarily a requirement, it definitely plays a crucial role in protecting what may be your greatest asset.

## What Does Home Insurance Cover?

Home insurance covers expenses that occur when something unexpected or accidental happens to your home and/or your belongings. That means that you'll receive financial protection against losses due to theft, fire, wind damage and much more.

Your standard policy can include coverage for:
- **Structure of your home** - Repair, reconstruction or replacement
- **Personal belongings** - Based on Replacement Cost or Actual Cash Value
- **Additional living expenses** - If you're unable to live in your home while it's being repaired
- **Liability protection** - If someone injures themselves on your property, or if you damage someone else's property

These policies can cover incidents that involve pets as well.

## Types of Home Insurance

### 1. Comprehensive Form (All Risk)
This is the highest tier of home insurance and the most common. Comprehensive coverage covers your home and belongings from all loss, with the exception of some exclusions which will be directly listed on your policy.

### 2. Broad Form
This is the mid-tier level of home insurance which provides more extensive coverage on bigger items such as the building itself and will provide basic coverage on other items that are specified on your policy.

### 3. Basic Form
This is the simplest level of insurance coverage offered, in which only certain items listed on your policy are covered. This option is usually suitable for those with seasonal cottages or camps. It's cheaper than the other options, however, you do carry more financial risk should anything happen to your home.

## What's Not Covered Under Home Insurance?

Coverage varies from policy to policy. Some exclusions are outright, meaning there are no options to add coverage for them. Common exclusions typically include:
- Wear and tear
- Damage caused by pests (such as rodents or insects)
- Acts of terrorism

Your policy is also likely to contain specific dollar limits and possible coverage restrictions on certain categories of items, such as jewelry or wine collections. If you have belongings of particularly high value, check these limits and restrictions to ensure you're properly covered.

## How Much Will Home Insurance Cost?

Just as how mortgage payments will differ from homeowner to homeowner, so will the cost of home insurance. What you pay for your home insurance premiums will depend on factors like:
- How much coverage you want
- The location of your home
- The age and construction of your home
- Your claims history
- The deductible you choose

Remember, cheaper may not always be better. Make sure you have adequate coverage for your needs.

*The content on this page is for general information purposes only and does not constitute legal advice. Coverages described herein may be subject to additional eligibility criteria, limitations and exclusions.*
