# How Car Insurance Deductibles Work

## What is a Deductible?

When you choose an insurance policy, you agree to a deductible amount and a premium—these are both costs that you agree to pay. **Deductibles are the dollar figure that you're responsible for paying upon settlement of an eventual claim**—the deductible is effectively deducted from your total claim settlement (hence the name).

Deductibles provide a way for your insurer to transfer back some of the risk associated with insuring your vehicle, which allows them to offer you a lower premium compared to what you'd have to pay with no deductible.

## How Does a Deductible Work?

If the damage inflicted costs significantly more than just your deductible amount, you'd only be responsible for paying out the deductible (smaller portion of the damage), whereas your insurer would cover the amount of damage in excess of your deductible.

### Example Scenario

Your vehicle is damaged in an at-fault accident, and your policy states a $1,000 Collision deductible. The repairs amount to $10,000.

**Option 1:** Your insurer sends you a claims cheque for $9,000 to cover the cost of repairs, and you pay $1,000 to your mechanic.

**Option 2:** You take your vehicle to a preferred repair shop. The insurer pays the repair shop directly, and you pay your $1,000 deductible when you pick up your vehicle.

### When Damage is Less Than Your Deductible

If your at-fault accident causes damages worth $500 and you have a $1,000 deductible, you'd be responsible for covering the damage from your own pocket—without the involvement of your insurer. **Any amount of damage less than the deductible amount would be your responsibility to repair and pay for.**

## Who Decides My Deductible?

You do—your insurer will provide you with options and will likely suggest a minimum and maximum deductible that you can choose from. This depends on the risk level you're willing to assume:

- **Lower deductible** = Higher premium, but you pay less out-of-pocket for claims
- **Higher deductible** = Lower premium, but you pay more out-of-pocket for claims

Regardless of the deductible you choose, you're agreeing to **self-insure up to a certain limit before your insurer kicks in their portion of coverage.**

## Types of Deductibles

Different types of deductibles typically come into play when you choose additional coverages on your policy:

- Specified Perils
- Comprehensive
- Collision
- All Perils

Depending on your province, you may also have a deductible on mandatory coverages such as Uninsured Automobile Coverage or Direct Compensation Property Damage.

### Example

You've gotten into an at-fault accident and are covered under Collision coverage. Your policy indicates a $1,000 Collision deductible and a $500 Comprehensive deductible. You would file a claim under Collision coverage and pay the $1,000 Collision deductible. The Comprehensive deductible would not apply since you did not file a claim under that specific coverage.

## When Would My Deductible Not Apply?

Consider these scenarios where you may not need to pay a deductible:

1. If you get into a not-at-fault accident and the third party (at-fault driver) is known and insured
2. If you experience a Hit & Run with certain coverage options that waive the deductible
3. If you file a claim under Comprehensive coverage for a chip/small crack in your windshield that can be repaired (province dependent)
4. In certain provinces, if you have additional coverage and experience a Total Loss due to fire, theft or lightning

*The content on this page is for general information purposes only and does not constitute legal advice.*
