# How Home Insurance Deductibles Work

## What is a Home Insurance Deductible?

A home insurance deductible is the amount you agree to pay first when settling an insurance claim. This allows the risk of insuring your home to be shared between you and your insurer.

It's important to consider whether submitting a claim makes sense, especially if the cost of your deductible exceeds the cost of your home's repairs. You should choose a deductible amount that's realistic for you to afford in case you need to submit a claim.

## How Does a Home Insurance Deductible Work?

### Example Scenario

Let's say you experience water damage caused by a burst pipe. After confirming your claim is eligible, you get the damage assessed and are told you have $5,000 in damages. With a $1,000 deductible, you have two options:

**Option 1:** You can opt for a cash settlement where you receive a payment (less $1,000 for your deductible) to hire a contractor of your choice to do the repairs.

**Option 2:** You can use one of your insurer's preferred contractors. You'll be responsible for paying your $1,000 deductible towards the contractor while your insurer covers the remaining balance.

### When Repairs Cost Less Than Your Deductible

If the cost of your repairs is less than your deductible, you'd have to pay for your repairs out of pocket since it wouldn't make sense to file a claim. Remember to always consider your deductible amount and the cost of repairs before proceeding with a claim. You may be losing out on potential claims-free savings over future renewals if you choose to proceed with smaller claims.

## The Relationship Between Deductible and Premium

Deductibles and premiums go hand in hand:

- **Higher deductible** = Typically lower premium
- **Lower deductible** = Typically higher premium

Your premium is simply the cost of your home insurance policy and what you pay to your insurer to keep your policy active. The amount you pay for your premium is decided by your insurer and is based on multiple factors:

- Where you live
- The age of your home
- The deductible and coverage you've chosen
- Your claims history

## How to Choose the Right Deductible Amount

Your insurer should be able to suggest a minimum and maximum deductible amount for you to choose from. From there, you'll need to assess your risk tolerance:

- **Lower deductible:** You'll pay less up-front costs during a claims settlement, but will typically have to pay a slightly higher premium.
- **Higher deductible:** You'll have to pay more up front during a claims settlement, but you'll pay slightly lower premiums.

It's important that you choose a deductible amount that you're comfortable with. If you do have to go through the claims process, you'll want to ensure you can afford to pay out the deductible. Take a look at your affordability and choose a deductible amount accordingly.

*The content on this page is for general information purposes only and does not constitute legal advice.*
