# Insurance Terminology: A Complete Glossary

Insurance-speak can be complicated. Unless you're fluent in the intricacies of floaters or fortuitous events, it can be difficult to decipher what your policy means. Here's a comprehensive glossary of insurance terms with easy-to-understand definitions.

## A

### Actual Cash Value
When resolving insurance claims, this takes into account how much an item has depreciated since it was new. For a 10-year-old TV, you'd receive compensation for a 10-year-old TV's value, not a new one.

### Actuary
Someone who assesses risk and determines how likely certain events are to happen, and as a result, how much insurance premiums should cost.

### Advisor
Professionals who work directly with customers to provide advice and guidance on what kinds of insurance policies are available, and what policy makes the most sense for each person, group or family.

## B

### Binding the Policy
After selecting your coverage, reviewing the quote, and accepting the terms, this is the final stage when the application for insurance is officially accepted.

## C

### Comprehensive Policy
A comprehensive policy covers the widest range of possible perils.

### Consequential & Direct Damage
- **Direct Damage:** Damage that happens to your property (e.g., a damaged laptop)
- **Consequential Damage:** Damage that results from the direct damage (e.g., you can't finish work because your laptop is damaged)

Direct damages are usually covered under home insurance policies, while consequential damages may be excluded.

## D

### Deductible
When filing an insurance claim, the deductible is the portion of a claim that you're responsible for paying. It's chosen by you, based on the value of whatever you're insuring.

## E

### Endorsement
When an insurance policy changes in scope—whether something is added, removed, or modified—those changes are called endorsements.

### Exclusions
Things that aren't covered by an insurance policy, like vermin, rodents, or wear and tear.

## F

### Floater
An addition to your policy that covers the value of expensive, easily moveable items (like jewelry) that exceed your base coverage limits.

### Fortuitous Event
An accident that occurs by chance, not on purpose. Fortuitous events may be covered by insurance. Damage done on purpose or because of neglect is likely not covered.

## G

### Guarantor
A person that vouches for you and confirms that what you say is accurate, and that you're able to hold up your end of the bargain.

## I

### Ice Dam
When ice clogs gutters in winter, preventing snow from draining properly. Melting snow can get under shingles and into walls, causing substantial damage.

## J

### Joint Tenancy
When two or more people co-own something, and if one person dies, ownership passes directly to the surviving parties.

## K

### Known Loss Rule
A rule that prevents making a claim on something that you lost or broke before the policy started. Also known as misrepresentation.

## M

### Mortgage Insurance
If you can't pay off the remainder of your mortgage due to death or disability, mortgage insurance steps in to pay off the remaining debt.

## O

### Omnibus Clause
Common in auto insurance policies, this means that if you lend someone your car, they're covered under your policy.

## P

### Perils
The forces or events that can cause damage to the thing you've insured. They range from common natural disasters (like lightning, wind, or hail) to rare events (like earthquakes).

### Policy
The document that details the terms and conditions of your insurance coverage.

### Policy Wording
The written terms and conditions of an insurance policy.

### Premium
What you pay to purchase insurance. Calculated using an algorithm that takes into account past behaviour to determine future risk.

## Q

### Quote
An assessment of what your insurance will cost, based on the coverage you selected and the information you've provided. While a quote isn't an official offer of insurance, it's usually close to what the final cost will be.

## R

### Replacement Cost
When resolving claims, this means you'll receive either a brand new version of your item, or a brand-new version of a comparable model.

### Reporting Lag
The period of time between when an incident occurs and when it's first reported to the insurer.

## S

### Subrogation
When an insurance claim involves a loss caused by a third-party, an insurance company has the right to pursue legal action on your behalf to cover the value of that claim.

## T

### Tertiary Beneficiary
The third person in line to receive life insurance benefits. If the first and second beneficiaries are deceased when the proceeds pay out, those proceeds go to the tertiary beneficiary.

*The content on this page is for general information purposes only.*
