# What to Do After a Car Accident

A car accident can be an intense experience to go through—and sometimes it's hard to remember what to do next. Follow these safety tips and steps to feel confident you'll be back on the road quickly.

## Put Your Safety First

After an accident, the most important thing is making sure you and everyone involved are okay.

### Safety Checklist
- Check for injuries. If someone is injured, call 911
- Move yourself out of harm's way
- If your car is driveable, move to the shoulder of the road or towards the nearest curb
- If there's broken glass, don't touch it
- Go to the side furthest from the road or stay in your car if it isn't safe to exit

## Safety Tips to Remember

### Do:
- Remain calm
- Take care of the needs of yourself and injured passengers
- Walk to or stay on the side furthest from the road
- Gather any materials that may have fallen off during the accident, like your bumper, if it's safe to do so
- Get a police report

### Don't:
- Touch glass, exposed wiring or anything that appears dangerous
- Leave your car in the middle of traffic if it can be driven to the side
- Abandon the scene of an accident
- Get into a confrontation with someone involved in the accident
- Accept offers from tow truck drivers that offer to take your car somewhere

## When You Need Assistance

There's a strong chance you'll need some form of help after an accident:
- Call your local police to report the accident
- If you can't drive your car, reach out to a loved one or call a taxi to get a ride
- Use your insurance company's mobile app to begin your new claim instantly

## Steps to Take with Your Insurance

Once you confirm that everyone's safe, you can start taking action on your insurance claim.

### Information to Exchange with Other Driver(s)
- Name
- Address
- Contact phone number
- Driver's licence number
- Insurance information (including policy number)
- Licence plate number
- Make, colour and model of the other car

### Document the Accident
- Take pictures of the scene and of any damage
- Capture witness contact information (if there are witnesses)
- Note the scene of the accident (major intersections, road conditions)
- Get a police report number

### Report the Incident
- Report to your insurance company within seven days
- If police are not at the scene, call your local police station to report the accident as soon as possible
- Report a hit and run to the police right away

## Provincial Requirements

What you do next after an accident might be shaped by where you are:

- **Atlantic Canada:** An accident must be reported to the police if the damage is significant, if there are any injuries, or if you suspect a crime (such as impaired driving).

- **Quebec:** If no one is injured, you will need to fill out a Joint Report with the other driver.

- **Ontario:** You should bring your car to a Collision Reporting Centre within 24 hours.

- **Alberta:** If the repair cost is high enough, you will need to bring your car to a Collision Reporting Centre to get a damage sticker, which the auto shop needs to begin repairs.

*The content on this page is for general information purposes only and does not constitute legal advice.*
