# How to File an Insurance Claim: Complete Guide

## Types of Insurance Claims

Insurance claims can be filed for various types of coverage:
- Car/Auto
- Home/Condo/Tenant
- Travel
- Life
- Accident & Sickness
- Motorcycle & RVs

## Auto Insurance Claims

### Before Starting Your Claim

Before starting your insurance claim, it's important to make sure you're safe first:
- Pull over to a safe spot and ensure there are no injuries
- If you see that someone is injured, don't move them
- Call 911 if there is an injury and try to stay calm
- Make sure you know where you are and make yourself visible

### What To Do If Your Car Is Damaged

Whether your car is drivable or not, start your claims process. Be prepared to provide:
- The year, make and model of all vehicle(s) involved
- The registration and license plate number of the vehicle(s) involved
- The driver's name and driver's license number
- The police officer's information or related police report (if involved)

### What To Do If Your Windshield Is Cracked

If your windshield or any other glass has been damaged:
- Notify your insurance company before you repair
- Inform them if the vehicle is safe to drive
- Work with a repair service you trust

Coverage for windows and windshields is typically found under Collision, Comprehensive and All Perils coverage.

### Common Car Accident Claims (Fender Benders)

1. Make sure everyone involved is safe and contact emergency services if needed
2. Report the incident to your insurer within seven days
3. Take note of surroundings: where it took place, weather conditions, and location
4. Be prepared to provide details on the incident

## Home Insurance Claims

### What to Do If Your Home Has Water Damage

If you have water damage from pipes bursting, rain, or overflowing:

1. **Turn off your home's main water lock-off tap** (typically found in your basement where the exterior water line enters your home)
2. If it's safe to do so, move all undamaged content from the affected area
3. Start to make a list of all damaged items in your home

### What to Do If Your House Is Damaged from Wind and Hail

1. Note the date the damage occurred
2. Start a detailed list describing the damages to your home and personal belongings
3. If wind or hail causes a power outage that results in lost freezer foods, include them in your list

### What to Do If There Has Been a Theft or Burglary

**Preparation (Before a Theft Occurs):**
- Keep a file of all receipts, appraisals and manuals for key contents
- Keep pictures or videos of your rooms and contents

**If a Burglary Happens:**
1. Call the police to report the incident and file a report
2. Wait for instructions from police before entering your home
3. Start a list describing the damages and loss to your home, property and personal belongings
4. Have the police report information on hand when reporting your claim

## Travel Insurance Claims

### In a Medical Emergency

Call your insurance administrator immediately, or as soon as reasonably possible. A delay could limit the maximum benefit payable under the policy.

### Filing a Travel Claim

1. **Go online or call your administrator** - Complete all steps in the "notify us of a claim" section and attach all required documentation
2. **Follow-up** - You may be contacted for additional information as your claim is assessed
3. **Decision** - You'll be notified of the decision by mail or secured email

## How to Appeal a Decision

If you're not satisfied with the outcome of your claim, you may appeal the decision. Submit your appeal along with any additional supporting documents through your insurer's claims portal or by mail.

*The content on this page is for general information purposes only and does not constitute legal advice.*
