# How to Prevent Water Damage in Your Home

## Understanding Water Damage

Did you know that water damage is Canada's most common home insurance claim? Having insurance coverage can help protect you when facing unwanted water from flooding, sudden springtime snow melting and other weather-related challenges. There's a lot you can do to prepare your home to prevent water damage.

## Water Damage Prevention Tips

### Keep Drains Clear
Keep your drains free of debris, like excess snow, leaves and ice. Watch for wayward toys, water-logged welcome mats and sports equipment that can block drainage.

### Maintain Your Roof
Little things like loose shingles or a poorly positioned eavestrough can cause needless frustration. Regular inspection and maintenance go a long way to prevent water damage.

### Know Your Home's Details
- Know where the water shut-off valves are
- Ensure doors, windows and wall penetrations are effectively sealed
- Consider whether you need a sump pump to prevent basement water damage

### Prevent Frozen Pipes
In extremely cold temperatures:
- Let cold water drip from faucets connected to pipes that may be in danger of freezing
- Running even a small trickle of water can prevent a frozen pipe
- Leave the heat at 13 degrees Celsius (or more) in winter if you're away from home for an extended period

## Types of Water Damage Typically Covered

Standard home insurance policies often include protection against sudden and accidental water damage caused by:
- Heating system failure (specific to houses heated with radiators that use water)
- Plumbing system failure
- Sprinkling system failure
- Leakage of water from a hot water tank, dishwasher or other domestic appliances
- Escape of water from a public watermain

**Important:** Water heater tanks typically need to be replaced before they reach 15 years or older to maintain coverage. Loss or damage caused by water from tanks 15 years or older may not be covered.

## Additional Water Damage Coverage

Consider adding extended water damage coverage if:
- You live on lower floors
- You have a storage locker at the lower level of your building
- You're in an area prone to flooding

Extended water damage coverage typically protects against:
- Sewer or septic back-up
- Sump pump failure
- Ground and surface water entering your home below ground level
- Heavy rainfalls or melting snow entering your home
- Overland flood due to rising or overflow of streams or bodies of freshwater

## Dealing with Water Damage When It Occurs

If you experience water damage:
1. Turn off your home's main water lock-off tap
2. Move all undamaged content from the affected area if safe to do so
3. Make a list of all damaged items
4. Contact your insurance company to start a claim

*The content on this page is for general information purposes only.*
