# Condo Insurance: Complete Guide and FAQ

## Why Get Personal Condo Insurance?

Personal condo insurance provides protection that goes beyond what you get with your condo corporation's coverage. A typical condo corporation's insurance policy covers only the main structure and common areas such as the lobby, elevators, and gym. A personal condo insurance policy fills in the gaps.

### What Personal Condo Insurance Covers:
1. Your personal property and belongings
2. Improvements and upgrades you've made to your unit (flooring, countertops, appliances, etc.)
3. Personal liability if you're held responsible for damage to another unit or injury to a visitor
4. Liability if a break or loss starts in your unit and damages others

## Personal Condo Insurance vs. Condo Corporation Insurance

| Coverage Type | Personal Condo Policy | Condo Corporation's Policy |
|--------------|----------------------|---------------------------|
| Building | Included (2nd payer) | Included (1st payer) |
| Condo Unit | Included | Included |
| Common Areas | - | Included |
| Content | Included | - |
| Personal Liability | Included | Included (common areas only) |
| Improvements and Betterments | Included | - |
| Loss Assessment | Included | - |
| Additional Living Expenses | Included | - |

## Types of Condo Corporation Policies

Before choosing personal condo insurance, determine which type of policy your condo corporation has:

1. **Type 1:** Covers fixtures in your condo (appliances, wiring, plumbing, carpets) but not personal property you own.

2. **Type 2:** Does not cover anything contained within your walls. May or may not cover plumbing and electrical systems.

Review your condo corporation's policy carefully to determine what your personal policy needs to cover.

## Coverage for Rented Condos

If you're renting out your condo, consider:

1. **Protecting your rental income:** Add protection for Additional Living Expenses and Fair Rental Value to protect your revenue if your unit becomes unfit for occupancy.

2. **Protecting your unit:** If you're renting through a home rental network, your policy may not cover damage caused by an occupant. Speak to an advisor about additional coverage options.

## Storage Locker Coverage

If your locker is inside your condo unit, your insurance policy may cover damages. If your locker is located outside your unit or building, you may need additional coverage.

## Determining the Right Amount of Coverage

Consider everything you own to determine the worth of your belongings:
- Appliances and furniture
- Clothing
- Jewelry
- Electronics

If you have high-value items (jewelry, artwork), you may need special or additional coverage to ensure they're properly protected.

## Most Common Claim: Water Damage

Close to 40% of home claims are due to water damage. Water can damage carpeting, floors, walls, furniture, electronics, and valuables.

Standard condo policies cover certain types of water damage (like a burst pipe or dishwasher leak), but not all types. Consider extended water damage coverage for additional protection.

## Optional Coverage Enhancements

### Extended Water Damage
Protects against:
- Sewer or septic back-up
- Sump pump failure
- Ground and surface water entering below ground level
- Overland flood

Recommended if:
- You live on lower floors
- You have a storage locker at the lower level
- Your building could be unfit for occupancy in the event of sewer back-up or flood

### Enhanced Additional Living Expenses
If you're temporarily relocated due to an insured loss, this covers additional living expenses. Ensure coverage is sufficient to cover temporary residence costs plus mortgage payments.

### Identity Theft
Every year in Canada, thousands of people fall victim to identity theft. Identity theft coverage can provide funds to help restore your identity and financial record.

## Questions for Getting a Quote

Be prepared to answer:
- In what year was your condominium building built?
- How old is the roof on your building?
- How is the condo heated? (Electric baseboards, central electric, central gas, etc.)
- Does the building have a fire alarm system?
- What is the total value of all your belongings?

## Ways to Save on Condo Insurance

- Being an alumnus or member of an affiliated group or professional association
- Having no claims history
- Installing a remote fire detection system
- Using an approved security system

## Glossary of Coverage Terms

| Term | Definition |
|------|------------|
| Content | Protection for your belongings including jewelry, clothes, electronics, appliances, furniture, etc. |
| Personal Liability | Coverage for bodily injury and property damage sustained by others for which you are legally responsible |
| Improvements and Betterments | Protection for upgrades you've made beyond what the building originally provided |
| Loss Assessment | Coverage when a special assessment is levied against unit holders for losses to common elements |
| Additional Living Expenses | Coverage for extra expenses if you must leave your home following an insured loss |
| Fair Rental Value | The amount of rent you would have received, less expenses that don't continue due to the loss |

*The content on this page is for general information purposes only and does not constitute legal advice.*
