# Winter Driving Safety Tips

## Preparing Your Car for Winter

### Tire Considerations

**Winter Tires:**
- Winter tires significantly improve traction in snow and ice
- They remain flexible in cold temperatures
- Many provinces require or recommend them
- Some insurers offer winter tire discounts

**All-Season vs. Winter vs. All-Weather:**
- **All-Season:** Suitable for mild winters, not ideal below 7°C
- **Winter:** Best performance in snow and ice
- **All-Weather:** Middle ground, marked with snowflake symbol, legal as "winter tires"

**Tire Maintenance:**
- Check tire pressure regularly (cold affects pressure)
- Ensure adequate tread depth
- Inspect for damage before winter arrives

### Vehicle Maintenance Checklist
- Battery: Cold weather strains batteries; have it tested
- Antifreeze: Ensure proper coolant mix for freezing temperatures
- Windshield: Fill washer fluid with winter-grade solution
- Wipers: Replace worn blades; consider winter blades
- Lights: Ensure all lights are working properly
- Brakes: Have them inspected before winter
- Heater/Defroster: Ensure they're working properly
- Emergency kit: Keep one in your vehicle

### Winter Emergency Kit
Essential items to keep in your car:
- Blanket
- Flashlight with extra batteries
- First aid kit
- Non-perishable snacks
- Water
- Ice scraper and snow brush
- Small shovel
- Jumper cables
- Road flares or reflective triangles
- Sand or cat litter (for traction)
- Warm clothes and boots

## Safe Driving Techniques

### Adjusting Your Driving Style
- **Reduce speed:** Allow more time to react
- **Increase following distance:** Leave 8-10 seconds instead of 3-4
- **Brake gently:** Avoid sudden stops
- **Accelerate slowly:** Prevent wheel spin
- **Steer smoothly:** Avoid sudden movements

### Handling Skids

**Front-Wheel Skid (Understeer):**
- Ease off the gas
- Don't brake suddenly
- Steer in the direction you want to go
- Wait for traction to return

**Rear-Wheel Skid (Oversteer):**
- Take your foot off the gas
- Steer in the direction the rear is sliding
- Once you regain control, straighten the wheel

### Black Ice Awareness
- Forms on bridges, overpasses, and shaded areas first
- Often invisible on the road
- If you hit black ice: Don't brake or steer suddenly
- Keep the wheel steady and let the car pass over it

### Visibility Tips
- Clear ALL snow and ice from your vehicle (roof, hood, lights, windows)
- Turn on headlights even during the day
- Use low beams in falling snow (high beams reflect off snow)
- Keep windshield washer fluid topped up

## Special Situations

### Driving in Heavy Snow
- Use low gears for better control
- Follow tracks of other vehicles when possible
- Avoid passing snow plows
- If visibility is near zero, pull over safely and wait

### Driving in Freezing Rain
- Most dangerous winter condition
- If possible, avoid driving
- If you must drive, reduce speed significantly
- Be aware that bridges and overpasses freeze first

### Getting Stuck in Snow
1. Don't spin your wheels (makes it worse)
2. Turn wheels from side to side to push snow away
3. Use a light touch on the gas
4. Rock the vehicle gently if equipped with automatic transmission
5. Use sand, kitty litter, or floor mats for traction
6. If truly stuck, call for help

## Winter Insurance Considerations

### Claims Considerations
- Winter accidents are common
- Review your coverage before winter
- Know your deductibles
- Understand what's covered (collision, comprehensive, etc.)

### Common Winter Claims
- Collision with other vehicles on icy roads
- Single-vehicle accidents due to loss of control
- Damage from hitting potholes hidden by snow
- Theft (cars left running to warm up)
- Vandalism
- Animal collisions (deer are active in winter)

### Preventing Theft
- Never leave your car running unattended
- Use remote starters that keep doors locked
- Don't leave valuables visible
- Park in well-lit areas

## Preparing for Freezing Rain

### Home Preparation
- Keep rock salt or ice melt on hand
- Have a flashlight ready for power outages
- Keep extra food and water available
- Know how to shut off water if pipes freeze

### Vehicle Preparation
- Park facing east (sun helps with de-icing)
- Cover windshield with a tarp or blanket
- Apply cooking spray to door seals to prevent freezing
- Keep de-icer spray accessible (not inside the car)

*The content on this page is for general information purposes only.*
