# Protecting Your Home from Fire

## Fire Prevention Basics

House fires are one of the most devastating events a homeowner can face. Prevention is the best protection. Here's how to reduce your risk and protect your family.

## Kitchen Safety

The kitchen is the leading cause of home fires.

### Cooking Safety Tips
- Never leave cooking unattended
- Keep flammable items away from the stove (towels, paper, curtains)
- Turn pot handles inward to prevent accidents
- Keep a lid nearby to smother grease fires
- Clean grease buildup regularly
- Keep appliances in good repair

### If a Cooking Fire Starts
- **Grease fire:** Never use water! Cover with a lid or use a fire extinguisher
- **Oven fire:** Turn off heat and keep door closed
- **Microwave fire:** Keep door closed, unplug if safe
- If fire spreads, get out and call 911

## Electrical Safety

Electrical issues are a common cause of home fires.

### Prevention Tips
- Don't overload outlets or extension cords
- Replace frayed or damaged cords immediately
- Use light bulbs with correct wattage
- Keep electrical appliances away from water
- Have older wiring inspected by a professional
- Use surge protectors for electronics
- Unplug appliances when not in use

### Warning Signs of Electrical Problems
- Frequently tripping circuit breakers
- Flickering lights
- Buzzing sounds from outlets
- Burning smells
- Warm or discolored outlets
- Sparking

## Heating Safety

Heating equipment is the second leading cause of home fires.

### Space Heater Safety
- Keep at least 3 feet (1 meter) away from anything flammable
- Never leave unattended
- Plug directly into wall outlet (not extension cords)
- Turn off when sleeping or leaving home
- Choose models with automatic shut-off features

### Fireplace and Wood Stove Safety
- Have chimneys cleaned and inspected annually
- Use a fireplace screen
- Never leave fires unattended
- Let ashes cool completely before disposal
- Store firewood away from the house
- Keep flammable materials away from fireplace

### Furnace Safety
- Have your furnace serviced annually
- Replace filters regularly
- Keep the area around furnace clear
- Ensure vents aren't blocked

## Smoke and Carbon Monoxide Alarms

### Smoke Alarm Requirements
- Install on every level of your home
- Install inside and outside sleeping areas
- Test monthly
- Replace batteries at least annually (or use 10-year batteries)
- Replace alarms every 10 years

### Carbon Monoxide Alarms
- Required near sleeping areas in most provinces
- Test regularly
- Replace according to manufacturer's instructions
- Know the symptoms of CO poisoning

## Fire Extinguishers

### Choosing the Right Extinguisher
- **Class A:** Ordinary combustibles (wood, paper, cloth)
- **Class B:** Flammable liquids (gasoline, oil)
- **Class C:** Electrical fires
- **Class ABC:** Multi-purpose (recommended for home use)

### Placement and Maintenance
- Keep on each floor of your home
- Keep one in the kitchen and garage
- Mount where easily accessible
- Learn how to use before an emergency (PASS: Pull, Aim, Squeeze, Sweep)
- Inspect monthly
- Replace or service as directed

## Creating an Escape Plan

### Planning Essentials
- Identify two exits from every room
- Choose a meeting spot outside
- Practice the plan with your family
- Include plans for children, elderly, and pets
- Know how to safely escape from upper floors

### During a Fire
- Get out fast—don't stop to gather belongings
- Stay low to avoid smoke
- Feel doors before opening (don't open if hot)
- Once out, stay out
- Call 911 from outside

## Seasonal Fire Safety

### Summer/BBQ Season
- Keep grills away from structures
- Clean grills regularly
- Never leave grills unattended
- Keep children and pets away from hot grills

### Winter/Holiday Season
- Water live Christmas trees daily
- Turn off holiday lights before bed
- Keep candles away from decorations
- Inspect holiday lights for damage
- Don't overload electrical outlets

### Campfire Safety
- Never leave campfires unattended
- Keep water nearby
- Ensure fires are completely extinguished
- Check local fire restrictions

## Home Insurance and Fire Protection

### Coverage Considerations
- Ensure adequate dwelling coverage for rebuilding
- Review personal property coverage
- Understand additional living expenses coverage
- Document your belongings for claims

### Premium Discounts
Many insurers offer discounts for:
- Monitored smoke alarms
- Home sprinkler systems
- Fire extinguishers
- Proximity to fire hydrants and stations
- Non-smoking households

## After a Fire

### Immediate Steps
1. Ensure everyone's safety
2. Contact your insurance company
3. Don't enter until authorities say it's safe
4. Document damage with photos
5. Keep receipts for emergency expenses
6. Secure the property if possible

*The content on this page is for general information purposes only.*
