# Identity Theft Protection and Insurance

## Understanding Identity Theft

Identity theft occurs when someone uses your personal information without permission to commit fraud or other crimes. In Canada, thousands of people fall victim to identity theft every year.

## Types of Identity Theft

### Financial Identity Theft
- Opening credit cards in your name
- Taking out loans using your identity
- Accessing your bank accounts
- Filing fraudulent tax returns

### Criminal Identity Theft
- Giving your name to police during an arrest
- Creating a criminal record in your name
- Using your identity for illegal activities

### Medical Identity Theft
- Using your information to obtain medical care
- Filing false insurance claims
- Getting prescriptions in your name

### Synthetic Identity Theft
- Combining real and fake information
- Creating new identities using your data
- Often harder to detect

## Warning Signs of Identity Theft

### Financial Red Flags
- Unfamiliar charges on your accounts
- Bills or statements you didn't expect
- Calls from collectors about debts you don't owe
- Denied credit for no apparent reason
- Missing mail or redirected mail

### Account Issues
- Unfamiliar accounts on your credit report
- IRS/CRA notices about unreported income
- Medical bills for services you didn't receive
- Denied insurance claims

## Preventing Identity Theft

### Protect Your Information
- Shred sensitive documents before discarding
- Don't carry your SIN card in your wallet
- Use strong, unique passwords
- Enable two-factor authentication
- Be cautious about sharing personal information

### Online Safety
- Use secure, encrypted websites (https)
- Avoid public Wi-Fi for sensitive transactions
- Keep software and antivirus updated
- Be wary of phishing emails and calls
- Monitor your accounts regularly

### Mail and Document Security
- Collect mail promptly
- Use a locked mailbox if possible
- Opt for electronic statements when available
- Store important documents securely

### Credit Monitoring
- Check your credit report regularly (free annually from each bureau)
- Consider credit monitoring services
- Set up alerts on your accounts
- Consider a credit freeze if high risk

## What to Do If You're a Victim

### Immediate Steps
1. **Document everything:** Keep records of all communications and actions
2. **Contact your financial institutions:** Report fraud and freeze affected accounts
3. **Place a fraud alert:** Contact credit bureaus (Equifax, TransUnion)
4. **File a police report:** Get a copy for your records
5. **Report to the Canadian Anti-Fraud Centre:** 1-888-495-8501

### Credit Bureau Contacts
- **Equifax Canada:** 1-800-465-7166
- **TransUnion Canada:** 1-800-663-9980

### Recovery Steps
- Close fraudulent accounts
- Dispute unauthorized charges
- Correct your credit report
- Monitor your credit ongoing
- Consider identity theft insurance for recovery costs

## Identity Theft Insurance

### What It Covers
Identity theft insurance typically covers the costs associated with recovering your identity:
- Legal fees
- Lost wages while resolving issues
- Notary and document costs
- Mailing expenses
- Credit report fees
- Professional recovery assistance

### What It Doesn't Cover
- Stolen money (usually covered by your bank)
- Actual financial losses from the theft
- Preventive measures
- Credit monitoring services (usually)

### Types of Coverage
**Expense Reimbursement:**
- Pays for costs you incur during recovery
- Covers professional help and legal fees
- Typical limits range from $15,000 to $50,000+

**Resolution Services:**
- Provides access to identity recovery specialists
- Professionals work on your behalf
- May include credit monitoring

### How to Get Identity Theft Insurance
- **As an add-on to home/tenant insurance:** Many insurers offer this
- **Standalone policies:** Available from specialty providers
- **Through your employer:** Some benefits packages include it
- **With credit cards:** Some premium cards offer protection

## Identity Theft and Your Other Insurance

### Home Insurance Connection
Many home and tenant insurance policies offer:
- Identity theft coverage as an optional add-on
- Basic coverage included in some comprehensive policies
- Access to recovery specialists

### What to Ask Your Insurer
- Is identity theft coverage included in my policy?
- What are the coverage limits?
- What expenses are covered?
- Are recovery services included?
- How do I file a claim?

## Tips for Businesses

### Protecting Customer Data
- Encrypt sensitive information
- Limit access to personal data
- Train employees on data protection
- Have a data breach response plan
- Consider cyber liability insurance

### Employee Identity Theft
- Secure payroll and HR systems
- Verify requests for personal information
- Use secure methods for tax documents
- Train staff to recognize phishing

*The content on this page is for general information purposes only.*
