# Small Business Insurance Guide

## Why Small Businesses Need Insurance

Running a small business involves risks that can threaten your livelihood. From property damage to customer injuries, the right insurance protects your investment and helps ensure business continuity.

## Types of Small Business Insurance

### Commercial General Liability Insurance
Protects against claims of:
- Bodily injury to customers or third parties
- Property damage you cause to others
- Advertising injury (libel, slander)
- Legal defense costs

**Who needs it:** Almost every business that interacts with customers, clients, or the public.

### Commercial Property Insurance
Covers your business property:
- Building (if owned)
- Equipment and machinery
- Inventory
- Furniture and fixtures
- Business records and documents

**Protection against:** Fire, theft, vandalism, weather damage, and other covered perils.

### Business Interruption Insurance
Covers lost income when you can't operate due to a covered event:
- Revenue loss during closure
- Operating expenses that continue
- Temporary relocation costs
- Employee wages

### Commercial Auto Insurance
For vehicles used for business:
- Liability coverage
- Physical damage coverage
- Coverage for employees driving
- Hired and non-owned auto coverage

**Important:** Personal auto insurance typically doesn't cover business use.

### Professional Liability Insurance (Errors & Omissions)
Protects professionals against claims of:
- Negligence
- Errors in professional service
- Failure to perform
- Misleading advice

**Who needs it:** Consultants, accountants, lawyers, IT professionals, real estate agents, and other professionals.

### Product Liability Insurance
If you manufacture, distribute, or sell products:
- Covers injuries caused by your products
- Property damage from product defects
- Legal defense costs

### Workers' Compensation Insurance
If you have employees:
- Covers employee injuries on the job
- Medical expenses and rehabilitation
- Lost wages
- Required in most provinces

### Cyber Liability Insurance
Protects against data breaches and cyber attacks:
- Data breach response costs
- Customer notification expenses
- Credit monitoring for affected customers
- Legal defense
- Regulatory fines

## Industry-Specific Coverage

### Retail and Restaurants
- Product liability
- Liquor liability (if applicable)
- Food spoilage coverage
- Customer injury protection

### Construction and Contractors
- Builder's risk insurance
- Tool and equipment coverage
- Completed operations coverage
- Installation floater

### Health and Beauty Services
- Professional liability
- Product liability
- Premises liability
- Equipment breakdown

### Professional Services
- Errors and omissions
- Cyber liability
- Employment practices liability

## How Business Insurance Premiums Are Calculated

### Factors That Affect Rates
- Type and size of business
- Industry and risk level
- Revenue and number of employees
- Location
- Claims history
- Coverage limits and deductibles
- Years in business

### Ways to Lower Premiums
- Implement safety programs
- Bundle multiple coverages
- Increase deductibles
- Maintain claims-free history
- Shop around and compare quotes

## Business Owner's Policy (BOP)

A Business Owner's Policy bundles common coverages:
- General liability
- Commercial property
- Business interruption

**Benefits:**
- Usually less expensive than buying separately
- Convenient single policy
- Simplified management
- Good for many small businesses

**Limitations:**
- May not cover all needs
- Coverage limits may be insufficient
- Some industries may not qualify

## Determining Coverage Needs

### Questions to Ask
1. What assets need protection?
2. What are the biggest risks to your business?
3. Do you have employees?
4. Do you work with clients on their property?
5. Do you own or lease your space?
6. What industry regulations apply?
7. Do you sell products or provide services?
8. Do you store customer data?

### Coverage Limits
Consider:
- Value of your business assets
- Potential liability exposure
- Contract requirements from clients
- Industry standards
- Worst-case scenarios

## Common Coverage Gaps

Many small businesses overlook:
- Cyber liability
- Employment practices liability
- Key person insurance
- Business interruption
- Flood insurance (often excluded)
- Equipment breakdown

## Making a Business Insurance Claim

### Before an Incident
- Document your assets and inventory
- Keep records of equipment and values
- Understand your policy and coverages
- Know your deductibles

### When an Incident Occurs
1. Ensure safety and prevent further damage
2. Document the damage with photos/video
3. Notify your insurance company promptly
4. Keep receipts for emergency expenses
5. Cooperate with the investigation
6. Keep detailed records of business impact

## Reviewing Your Coverage

Review your business insurance annually and when:
- You add employees
- You add new services or products
- You purchase significant equipment
- You move locations
- You sign contracts with new requirements
- Industry regulations change

*The content on this page is for general information purposes only and does not constitute legal advice.*
