# Emergency Preparedness Guide

## Why Emergency Preparedness Matters

Emergencies can happen without warning—natural disasters, power outages, severe weather, and other events can disrupt your life. Being prepared helps protect your family and can minimize damage to your property.

## Building an Emergency Kit

### Basic Emergency Kit Supplies
Keep these items accessible in a waterproof container:

**Water and Food:**
- Water (4 liters per person per day for 3 days minimum)
- Non-perishable food for 3 days
- Manual can opener
- Paper plates and plastic utensils

**First Aid and Medical:**
- First aid kit
- Prescription medications (keep a 3-day supply)
- Extra glasses or contacts if needed
- Any necessary medical equipment

**Light and Communication:**
- Flashlight with extra batteries
- Battery-powered or hand-crank radio
- Extra batteries
- Cell phone charger (battery-powered)

**Personal Items:**
- Warm clothing and sturdy shoes
- Rain gear
- Blankets or sleeping bags
- Personal hygiene items

**Documents:**
- Copies of important documents in waterproof bag
- Cash in small bills
- Emergency contact list
- Insurance policy information

**Tools:**
- Multi-purpose tool
- Duct tape
- Plastic sheeting
- Whistle

### Additional Considerations
- Pet supplies if applicable
- Baby supplies if applicable
- Entertainment items (games, books)
- Maps of your local area

## Creating an Emergency Plan

### Household Plan Elements

**Communication Plan:**
- Designate an out-of-area contact person
- Make sure everyone knows the contact's number
- Plan how you'll communicate if separated
- Identify meeting places (near home and farther away)

**Evacuation Plan:**
- Know your local evacuation routes
- Identify at least two ways out of each room
- Practice the plan with your family
- Know where you would go if evacuated
- Plan for pets

**Special Needs:**
- Document any special medical needs
- Plan for mobility issues
- Consider hearing or vision impairments
- Have plans for children and elderly family members

## Preparing Your Home

### Before an Emergency

**Structural Safety:**
- Secure water heater and major appliances
- Know how to shut off utilities (gas, water, electricity)
- Identify potential hazards and address them
- Ensure smoke and CO detectors work

**Insurance Review:**
- Verify your coverage is adequate
- Document your belongings (photos, videos, inventory)
- Store documentation off-site or in cloud
- Know your policy's exclusions

**Home Inventory:**
- List all valuable possessions
- Include serial numbers and descriptions
- Take photos and videos room by room
- Store copies with someone you trust

### Specific Emergency Preparations

**For Severe Storms:**
- Trim trees near your home
- Secure outdoor furniture
- Clear gutters and drains
- Know your safe room location

**For Winter Emergencies:**
- Insulate pipes to prevent freezing
- Have alternative heating plan
- Stock winter emergency supplies
- Keep car's gas tank at least half full

**For Flooding:**
- Know your flood risk
- Consider flood insurance
- Keep sandbags available if in flood zone
- Know evacuation routes to higher ground

**For Power Outages:**
- Have flashlights accessible
- Consider a generator (use safely)
- Know how to manually open garage door
- Stock non-perishable foods

## During an Emergency

### General Guidelines
- Stay calm and think before acting
- Follow instructions from authorities
- Keep your emergency radio on for updates
- Check on neighbors if safe to do so

### If You Must Evacuate
- Follow official evacuation routes
- Take your emergency kit
- Secure your home before leaving
- Notify your out-of-area contact
- Keep important documents with you

### If You Shelter in Place
- Close all windows and doors
- Turn off heating/cooling systems if directed
- Go to your designated safe room
- Monitor news for updates
- Conserve water if needed

## After an Emergency

### Returning Home Safely
- Only return when authorities say it's safe
- Watch for hazards (downed power lines, gas leaks, structural damage)
- Document any damage before cleanup
- Wear protective gear during cleanup

### Filing Insurance Claims
1. Contact your insurance company promptly
2. Take photos and videos of all damage
3. Make a list of damaged items
4. Keep receipts for emergency expenses
5. Don't throw away damaged items until insurer approves
6. Get written estimates for repairs

### Recovery Resources
- Canadian Red Cross
- Local emergency management office
- Insurance company claims support
- Community assistance programs

## Maintaining Preparedness

### Regular Reviews
- Check and rotate emergency supplies every 6 months
- Update emergency contacts as needed
- Review and practice your plan annually
- Update home inventory after major purchases

### Stay Informed
- Sign up for local emergency alerts
- Know your community's warning signals
- Follow local emergency management on social media
- Participate in community emergency exercises

*The content on this page is for general information purposes only.*
