# Complete Guide to Insurance Savings

## Auto Insurance Savings

### Discounts to Ask About

**Safe Driver Discounts:**
- Claims-free record discounts
- Defensive driving course completion
- Usage-based insurance programs (telematics)
- Low mileage discounts

**Vehicle Discounts:**
- Anti-theft device installation
- Winter tire discounts (in applicable provinces)
- Green vehicle/hybrid discounts
- New vehicle discounts
- Multiple vehicle discounts

**Customer Discounts:**
- Multi-policy bundle (home + auto)
- Loyalty discounts for staying with one insurer
- Alumni and professional group discounts
- Payment discounts (annual vs. monthly)
- Paperless/electronic communication discounts

### Cost-Reducing Strategies

**Choose Your Vehicle Wisely:**
- Research insurance costs before buying
- Avoid high-theft vehicles
- Choose vehicles with good safety ratings
- Consider used vs. new

**Adjust Your Coverage:**
- Higher deductibles = lower premiums
- Review coverage on older vehicles
- Remove unnecessary add-ons
- Match coverage to vehicle value

**Maintain a Good Driving Record:**
- Avoid accidents and tickets
- Take defensive driving courses
- Consider accident forgiveness coverage

## Home Insurance Savings

### Available Discounts

**Safety Discounts:**
- Alarm system (monitored)
- Smoke and CO detectors
- Fire extinguishers
- Deadbolt locks
- Security cameras
- Water leak detection devices

**Property Discounts:**
- New home discount
- Renovated electrical/plumbing/heating
- Claims-free history
- Mortgage-free discount
- Age-related discounts (55+)

**Customer Discounts:**
- Bundle with auto insurance
- Loyalty/renewal discounts
- Group/affinity discounts
- Pre-authorized payment

### Cost-Reducing Strategies

**Increase Your Deductible:**
- Higher deductible means lower premium
- Make sure you can afford the deductible
- Compare savings vs. risk

**Review Coverage Regularly:**
- Don't over-insure
- Update coverage as belongings change
- Review replacement cost estimates
- Check for duplicate coverage

**Maintain Your Home:**
- Update old wiring, plumbing, heating
- Maintain your roof
- Address structural issues
- Reduce claims by preventing damage

## Tenant Insurance Savings

### Ways to Save
- Bundle with auto insurance
- Install renter-approved security devices
- Choose higher deductible
- Join alumni or professional groups for discounts
- Maintain claims-free history
- Ask about payment discounts

### Common Overlooked Savings
- Group discounts through employers
- Student discounts
- Electronic communication discounts
- Prior coverage discounts

## General Savings Strategies

### 1. Shop Around Regularly
- Compare quotes annually
- Use online comparison tools
- Get quotes from multiple insurers
- Don't just compare price—check coverage

### 2. Bundle Policies
- Combine home and auto
- Add other policies (motorcycle, RV, life)
- Look for package deals
- Calculate if bundling truly saves money

### 3. Pay Annually
- Monthly payments often include fees
- Annual payment may offer discounts
- Set aside money monthly if needed
- Ask about payment plan discounts

### 4. Maintain Good Credit
- Credit score can affect insurance rates
- Pay bills on time
- Keep credit utilization low
- Check your credit report for errors

### 5. Review Coverage Annually
- Life changes affect insurance needs
- Remove coverage you no longer need
- Update coverage amounts appropriately
- Don't over-insure or under-insure

### 6. Ask About All Available Discounts
- Don't assume discounts are applied
- Ask specifically what discounts exist
- Inquire about group associations
- Check employer-offered insurance programs

### 7. Increase Deductibles Strategically
- Higher deductibles lower premiums
- Only if you can afford the deductible
- Calculate break-even point
- Consider for each type of coverage

### 8. Be Loyal (When It Pays)
- Some insurers offer loyalty discounts
- Compare loyalty savings to competitor rates
- Don't stay loyal if rates are much higher elsewhere

## What NOT to Do to Save Money

### Risky Cost-Cutting
- **Don't underinsure:** Saving on premiums can cost you in a claim
- **Don't skip coverage:** Gaps can be devastating
- **Don't lie on applications:** Can void your policy
- **Don't let coverage lapse:** Gaps increase future rates

### Coverage Mistakes
- Canceling coverage too early on financed vehicles
- Reducing liability below recommended minimums
- Ignoring flood or earthquake risks
- Not updating coverage after major life changes

## Calculating True Savings

When comparing policies, consider:
- Total annual premium (not just monthly)
- Deductible amounts
- Coverage limits and types
- Exclusions and limitations
- Claims handling reputation
- Financial stability of insurer

### Example Comparison
Don't just pick the cheapest policy:

| Factor | Policy A | Policy B |
|--------|----------|----------|
| Premium | $1,200/year | $1,000/year |
| Deductible | $500 | $1,000 |
| Coverage Limit | $2M | $1M |
| Claims Satisfaction | High | Average |

Policy A may be better value despite higher premium.

## When to Review Your Insurance

**Annual Reviews:**
- Before each renewal
- When shopping for new policies

**Life Changes:**
- Moving to a new home
- Buying a new vehicle
- Getting married or divorced
- Having children
- Major purchases
- Starting a home business
- Retirement

*The content on this page is for general information purposes only.*
